@extends('layouts/layoutMaster')

@section('title', 'Progress bars - UI elements')

@section('content')
  <div class="row gy-6">
    <!-- Options -->
    <div class="col-lg-12">
      <div class="card">
        <h5 class="card-header">Progress bars</h5>
        <div class="card-body">
          <div class="small fw-medium">Default</div>
          <div class="demo-vertical-spacing">
            <div class="progress">
              <div class="progress-bar" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0"
                aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar w-75" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100">
              </div>
            </div>
          </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
          <div class="small fw-medium">Height</div>
          <div class="demo-vertical-spacing">
            <div class="progress" style="height: 8px;">
              <div class="progress-bar" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0"
                aria-valuemax="100"></div>
            </div>
            <div class="progress" style="height: 16px;">
              <div class="progress-bar" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0"
                aria-valuemax="100"></div>
            </div>
          </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
          <div class="small fw-medium">With Label</div>
          <div class="demo-vertical-spacing">
            <div class="progress" style="height: 16px;">
              <div class="progress-bar" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0"
                aria-valuemax="100">25%</div>
            </div>
            <div class="progress" style="height: 16px;">
              <div class="progress-bar" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0"
                aria-valuemax="100">75%</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Options -->

    <!-- Backgrounds -->
    <div class="col-lg-12">
      <div class="card">
        <h5 class="card-header">Backgrounds</h5>
        <div class="card-body">
          <div class="demo-vertical-spacing demo-only-element">
            <div class="progress">
              <div class="progress-bar bg-primary" role="progressbar" style="width: 20%" aria-valuenow="20"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-secondary" role="progressbar" style="width: 30%" aria-valuenow="30"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-success" role="progressbar" style="width: 40%" aria-valuenow="40"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-danger" role="progressbar" style="width: 75%" aria-valuenow="75"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-warning" role="progressbar" style="width: 60%" aria-valuenow="60"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-info" role="progressbar" style="width: 50%" aria-valuenow="50"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar bg-dark" role="progressbar" style="width: 85%" aria-valuenow="85"
                aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Backgrounds -->

    <!-- Striped -->
    <div class="col-lg-12">
      <div class="card">
        <h5 class="card-header">Striped</h5>
        <div class="card-body">
          <div class="demo-vertical-spacing demo-only-element">
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-primary" role="progressbar" style="width: 20%"
                aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-secondary" role="progressbar" style="width: 30%"
                aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: 40%"
                aria-valuenow="40" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-danger" role="progressbar" style="width: 75%"
                aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-warning" role="progressbar" style="width: 60%"
                aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-info" role="progressbar" style="width: 50%"
                aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped bg-dark" role="progressbar" style="width: 85%"
                aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Striped -->

    <!-- Animated -->
    <div class="col-lg-12">
      <div class="card">
        <h5 class="card-header">Animated</h5>
        <div class="card-body">
          <div class="demo-vertical-spacing demo-only-element">
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar"
                style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-secondary" role="progressbar"
                style="width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar"
                style="width: 40%" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-danger" role="progressbar"
                style="width: 75%" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-warning" role="progressbar"
                style="width: 60%" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar"
                style="width: 50%" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="progress">
              <div class="progress-bar progress-bar-striped progress-bar-animated bg-dark" role="progressbar"
                style="width: 85%" aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Animated -->

    <!-- Multiple bars -->
    <div class="col-lg-12">
      <div class="card">
        <h5 class="card-header">Multiple bars</h5>
        <div class="card-body">
          <div class="small fw-medium mb-1">Default</div>
          <div class="progress mb-4">
            <div class="progress-bar bg-primary" role="progressbar" style="width: 15%" aria-valuenow="15"
              aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-success" role="progressbar" style="width: 30%" aria-valuenow="30"
              aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-danger" role="progressbar" style="width: 20%" aria-valuenow="20"
              aria-valuemin="0" aria-valuemax="100"></div>
          </div>

          <div class="small fw-medium mb-1">Striped</div>
          <div class="progress mb-4">
            <div class="progress-bar bg-primary progress-bar-striped" role="progressbar" style="width: 15%"
              aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-success progress-bar-striped" role="progressbar" style="width: 30%"
              aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-danger progress-bar-striped" role="progressbar" style="width: 20%"
              aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
          </div>

          <div class="small fw-medium mb-1">Animated</div>
          <div class="progress">
            <div class="progress-bar bg-primary progress-bar-striped progress-bar-animated" role="progressbar"
              style="width: 15%" aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-success progress-bar-striped progress-bar-animated" role="progressbar"
              style="width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
            <div class="progress-bar bg-danger progress-bar-striped progress-bar-animated" role="progressbar"
              style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
          </div>
        </div>
      </div>
    </div>
    <!--/ Multiple bars -->
  </div>
@endsection
